<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  Content.vote
 *
 * @copyright   Copyright (C) Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * Layout variables
 * -----------------
 * @var   string   $context  The context of the content being passed to the plugin
 * @var   object   &$row     The article object
 * @var   object   &$params  The article params
 * @var   integer  $page     The 'page' number
 * @var   array    $parts    The context segments
 * @var   string   $path     Path to this file
 */

use Joomla\CMS\Language\Text;

if ($context == 'com_content.categories')
{
    return;
}

$rating = (int) $row->rating;
$rcount = (int) $row->rating_count;

// Look for images in template if available
$starImageOn  = '<svg width="20" height="20" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg" data-svg="star"><polygon points="10 2 12.63 7.27 18.5 8.12 14.25 12.22 15.25 18 10 15.27 4.75 18 5.75 12.22 1.5 8.12 7.37 7.27" fill="red" stroke="none" stroke-width="0"></polygon></svg>';
$starImageOff = '<svg width="20" height="20" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg" data-svg="star"><polygon points="10 2 12.63 7.27 18.5 8.12 14.25 12.22 15.25 18 10 15.27 4.75 18 5.75 12.22 1.5 8.12 7.37 7.27" fill="red" stroke="none" stroke-width="0" style="opacity:.7;"></polygon></svg>';

$img = '';

for ($i = 0; $i < $rating; $i++)
{
    $img .= $starImageOn;
}

for ($i = $rating; $i < 5; $i++)
{
    $img .= $starImageOff;
}

?>
<div class="uk-flex content_rating">
    <?php echo $img; ?>
    <?php if ($rcount) { ?>
        <p class="uk-display-inline-block uk-margin-small-left unseen element-invisible" itemprop="aggregateRating" itemscope itemtype="https://schema.org/AggregateRating">
            <?php echo Text::sprintf('PLG_VOTE_USER_RATING', '<span itemprop="ratingValue">' . $rating . '</span>', '<span itemprop="bestRating">5</span>'); ?>
            <meta itemprop="ratingCount" content="<?php echo $rcount; ?>" />
            <meta itemprop="worstRating" content="1" />
        </p>
    <?php } ?>
</div>
