# Security Policies and Procedures

This document outlines security procedures and policies for the `Joomla! Project`.

  * [Reporting a Bug](#reporting-a-bug)
  * [Response Handling](#response-handling)
  * [Security Announcement Policy](#security-announcement-policy)
  * [Further Details on the Joomla! Security Policies](https://security.joomla.org)

## Reporting a Bug

The `Joomla` team and community take all security bugs in `Joomla` seriously. The Joomla! Security Strike Team (JSST) oversees the project's security issues and follows some specific procedures when dealing with these issues.

If you find a possible vulnerability, please report it to the JSST using the [online form](https://developer.joomla.org/security/contact-the-team.html) or via email at security@joomla.org 

We maintain a list of [GPG keys and addresses](https://developer.joomla.org/security/gpg-keys.html) for the security@joomla.org address and members of the JSST to allow signed and encrypted communications.

To report an issue in a Joomla! extension, please submit it to the [Vulnerable Extensions List.](https://vel.joomla.org/submit-vel)

For support with a site which has been attacked, please visit the [Joomla! Forum.](https://forum.joomla.org/viewforum.php?f=714)

Thank you for improving the security of `Joomla`.

## Response Handling

The JSST aims to ensure all issues are handled in a timely manner and for clear communication between the team and issue reporters. We have established the following guidelines for responding to issue reports:

* Within 24 hours every report gets acknowledged
* Within 7 days every report gets a further response stating either
    * the issue is closed (and why)
    * the issue is still under investigation; if needed, additional information will be requested
* Within 21 days every report must be resolved unless there are exceptional circumstances requiring additional time

## Security Announcement Policy
* Verified vulnerabilities will only be publicly announced AFTER a release is issued which fixes the vulnerability.
* All announcements will contain as much information as possible, but will NOT contain step-by-step instructions for the vulnerability.
* The `Joomla! Project` will properly credit individuals and/or organizations who responsibly disclose security issues to the JSST. You can indicate the way you would like to be referred to in the advisory about the vulnerability. Our preference is to use full names. If you do not specify then we will use the contact name associated with the email address the report was received from. You can also request a pseudonym or having your name withheld.
